<?php

// types of string search engines...
$engines_dict = array("Live" => "Live",
	"Indexed" => "Indexed",
	"Other" => "Other",);

// data sets...
$datasets_dict = array("Windows" => "Windows: FAT, ExFat and NTFS",
	"UNIX" => "UNIX: ext4, APFS (Apple File System), OSX Journaled and OSX Case-sensitive",);

/******************************************************
 ******************************************************
 		SHORT/ABBREVIATED TEST CASE DESCRIPTIONS
 ******************************************************
 ******************************************************/

// test cases for "basic" string search features
/*$basic_dict = array("FT-SS-01" => "Search ASCII",
	"FT-SS-02a" => "Search ignore case",
	"FT-SS-02b" => "Search for a substring",
	"FT-SS-03" => "Search for words (whole word match vs a substring match)",);*/

$basic_dict = array("FT-SS-01" => "Find an ASCII string",
	"FT-SS-02" => "Search for a substring and search ignore case",
	"FT-SS-03" => "Search for words (whole word match vs a substring match)",);

$basic_dict_extended = array("FT-SS-01" => "Find an ASCII string",
	"FT-SS-02a" => "Search ignore case",
	"FT-SS-02b" => "Search for a substring",
	"FT-SS-03" => "Search for words (whole word match vs a substring match)",);

// test cases for testing logical combinations
$logical_dict = array("FT-SS-04" => "Search Logical AND",
	"FT-SS-05" => "Search Logical OR",
	"FT-SS-06" => "Search Logical NOT",);

// unicode
$unicode_dict = array("FT-SS-07-Latin" => "Search Unicode Latin characters with diacritical marks",
	"FT-SS-07-CJK-char" => "Search Unicode Chinese/Japanese ideograms (Asian)",				  
	"FT-SS-07-CJK-hangul" => "Search Unicode CJK Korean Hangul (Asian)",
    "FT-SS-07-CJK-kana" => "Search Unicode CJK Japanese phonetic Kana (Asian)",
	"FT-SS-07-Cyrillic" => "Search Unicode Cyrillic (Russian)",
	"FT-SS-07-RTL" => "Search Unicode Right-To-Left (Arabic)",
	"FT-SS-07-NoBOM" => "Search Unicode 16 without a byte-order-mark.",
	"FT-SS-07-Norm" => "Search Unicode for normalized diacritic marks (NFC &amp; NFD) and ligatures (NFKC &amp; NFKD)",);

// tool-defined queries...
$tool_defined_dict = array("FT-SS-08-Email" => "Search tool-defined queries -- Email Address",
	"FT-SS-08-Phone" => "Search tool-defined queries -- Telephone Number",
	"FT-SS-08-SS" => "Search tool-defined queries -- Social Security Number",);

// special cases
$special_dict = array("FT-SS-09-Doc" => "Search Formatted Document Text",
	"FT-SS-09-Frag" => "Search Fragmented File",				  
	"FT-SS-09-Lost" => "Search Inaccessible (lost) Areas",
    "FT-SS-09-MFT" => "Search File in MFT",
	"FT-SS-09-Meta" => "Search file name substring in Meta-data",
	"FT-SS-09-Stem" => "Search for matches to word stem",);

// regular expressions
$regex_dict = array("FT-SS-10-Hex" => "Search Hexadecimal Character Match",
	"FT-SS-10-Regex" => "Search Pattern Character Match",);

// these test cases don't apply to the UNIX data set
$ignore_for_unix = array('FT-SS-09-Frag', 'FT-SS-09-Lost', 'FT-SS-09-MFT');

/******************************************************
 ******************************************************
 		FULL TEST CASE DESCRIPTIONS
 ******************************************************
 ******************************************************/

//	"FT-SS-02" => "Search for substring matches of an ASCII string while ignoring case",
//	"FT-SS-07-Latin" => "Search for target strings containing Latin characters with diacritic marks such as umlauts  or cedillas.",

$full_case_desc = array("FT-SS-01" => "Search for an ASCII string.",
	"FT-SS-02" => "Search for substring matches of an ASCII string and test the ignore case setting.",
	"FT-SS-03" => "Search for an ASCII string that is a word. Test searching for a whole word match versus a substring match.",
	"FT-SS-04" => "Search logical AND. Search for a file that contains two target strings, e.g., a file with both the string 'panda' and the string 'fox.'",
	"FT-SS-05" => "Search logical OR. Search for a file that contains either of two search strings, e.g., either the string 'Were' or the string 'DireW.'",
	"FT-SS-06" => "Search logical NOT. Search for a file that contains one string, but not another given string, e.g., file contains the string 'fox', but the file does not contain the string 'tiger.'",
	"FT-SS-07-Latin" => "Search for Unicode target strings containing Latin characters with diacritic marks such as umlauts, accents, tildes or cedillas.",
	"FT-SS-07-CJK-char" => "Search for Unicode Chinese and Japanese strings.",				  
	"FT-SS-07-CJK-hangul" => "Search for a Unicode Korean Hangul character.",
    "FT-SS-07-CJK-kana" => "Search for a Unicode string in each of the Japanese syllabic scripts, katakana and hiragana.",
	"FT-SS-07-Cyrillic" => "Search for a Unicode Cyrillic Russian string.",
	"FT-SS-07-RTL" => "Search for a Unicode target string in a language written right-to-left, such as Hebrew, Arabic, Farsi or Urdu.",
	"FT-SS-07-NoBOM" => "Search for Unicode 16 target strings from files that do not have byte-order-marks.",
	"FT-SS-07-Norm" => "Search for Unicode strings with normalized diacritic marks (NFC &amp; NFD) and ligatures (NFKC &amp; NFKD).",
	"FT-SS-08-Email" => "Search for email addresses using a tool-defined query.",
	"FT-SS-08-Phone" => "Search for telephone numbers using a tool-defined query.",
	"FT-SS-08-SS" => "Search for social security numbers using a tool-defined query.",
	"FT-SS-09-Doc" => "Search for strings with embedded formatting, e.g., bold, underline, italics, in .doc, .docx, and html documents.",
	"FT-SS-09-Frag" => "Search for target strings that are split across two file fragments. The targets will not be found if a tool searches the test image in physical order rather than logical file order.",				  
	"FT-SS-09-Lost" => "Search for target strings that are placed in locations that are inaccessible to normal file system operations, e.g., in a system area before any partitions, in partition slack after the last cluster, or after the last partition but before the end of the storage device.",
    "FT-SS-09-MFT" => "Search for a string contained within a file stored in the Master File Table (\$MFT) of an NTFS file system.",
	"FT-SS-09-Meta" => "Search for target strings that are substrings of file names.",
	"FT-SS-09-Stem" => "Search for matches to word stem. Test stemming search, i.e., find all the inflected forms of word-stems, not just the word itself.",
	"FT-SS-10-Hex" => 'Search for a string of hexadecimal characters, e.g., search for \x70\x61\x6e\x64\x61, the ASCII string "panda."',
	"FT-SS-10-Regex" => "Search with a simple regular expression pattern, e.g., [abc] (match either a or b or c).",);


/* Call this function with a given search engine, data set, the path to where the se's results 
   are stored, and the list of test cases the user selected to run to find out if all the test 
   cases have been run for that data set-search engine combination...     
	 */
function is_se_tested($ds, $se, $base, $testcases) {
	
	global $d_dict, $ignore_for_unix;

	$is_tested = TRUE;
	
	foreach ($testcases as $testcase){
		if (!((strcmp($ds,'UNIX') == 0) and (in_array($testcase, $ignore_for_unix)))){ // some test cases don't apply to the UNIX data set... skip/ignore/don't print these if we're testing the UNIX data set
			// if any of the cases is missing a log file, then more tests need to be run 
			if (!file_exists($base.'/'.$testcase.'.txt')){
				$is_tested = FALSE;
			}
		}
	}
	
	return $is_tested;
}	 
		

?>